﻿Public Class SkyBox
    Inherits DrawableGameComponent

    Public SkyBoxModel As Model
    Public SkyBoxEffect As Effect
    Public SkyBoxTexture As TextureCube
    Public SkyBoxModelName As String
    Public SkyBoxEffectName As String
    Public SkyBoxTextureName As String
    Public Size As Single
    Public World As VirtualWorld

    Sub New(game As Game, world As VirtualWorld, modelName As String, effectName As String, textureName As String, size As Single)
        MyBase.New(game)
        Me.Game.Components.Add(Me)
        Me.Size = size
        Me.World = world
        Me.SkyBoxModelName = modelName
        Me.SkyBoxEffectName = effectName
        Me.SkyBoxTextureName = textureName
        Me.DrawOrder = 98
    End Sub

    Protected Overrides Sub LoadContent()
        Me.SkyBoxEffect = Me.Game.Content.Load(Of Effect)(Me.SkyBoxEffectName)
        Me.SkyBoxTexture = Me.Game.Content.Load(Of TextureCube)(Me.SkyBoxTextureName)
        Me.SkyBoxModel = Me.Game.Content.Load(Of Model)(Me.SkyBoxModelName)
        MyBase.LoadContent()
    End Sub

    Public Overrides Sub Draw(gameTime As Microsoft.Xna.Framework.GameTime)
        Dim originalRasterizerState As RasterizerState = Me.GraphicsDevice.RasterizerState
        Dim rasterizerState As New RasterizerState
        rasterizerState.CullMode = CullMode.None
        Me.GraphicsDevice.RasterizerState = rasterizerState
        'draw the skybox
        For Each pass As EffectPass In Me.SkyBoxEffect.CurrentTechnique.Passes
            pass.Apply()
            For Each mesh As ModelMesh In Me.SkyBoxModel.Meshes
                For Each part As ModelMeshPart In mesh.MeshParts
                    part.Effect = Me.SkyBoxEffect
                    part.Effect.Parameters("World").SetValue(Matrix.CreateScale(Me.Size) * Matrix.CreateTranslation(Me.World.CameraPosition))
                    part.Effect.Parameters("View").SetValue(Me.World.ViewMatrix)
                    part.Effect.Parameters("Projection").SetValue(Me.World.ProjectionMatrix)
                    part.Effect.Parameters("SkyBoxTexture").SetValue(Me.SkyBoxTexture)
                    part.Effect.Parameters("CameraPosition").SetValue(Me.World.CameraPosition)
                Next
                mesh.Draw()
            Next
        Next
        'reset the rasterizer state
        Me.GraphicsDevice.RasterizerState = originalRasterizerState
        MyBase.Draw(gameTime)
    End Sub

End Class
